/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SerializerHelper {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private SerializerHelper() {
    }

    public static FloatingLong getFloatingLong(@Nonnull JsonObject json, @Nonnull String key) {
        if (!json.has(key)) {
            throw new JsonSyntaxException("Missing '" + key + "', expected to find an object");
        }
        JsonElement jsonElement = json.get(key);
        if (!jsonElement.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a json primitive representing a FloatingLong");
        }
        try {
            return FloatingLong.parseFloatingLong(jsonElement.getAsNumber().toString(), true);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException("Expected '" + key + "' to be a valid FloatingLong (positive decimal number)");
        }
    }

    private static void validateKey(@Nonnull JsonObject json, @Nonnull String key) {
        if (!json.has(key)) {
            throw new JsonSyntaxException("Missing '" + key + "', expected to find an object");
        }
        if (!json.get(key).isJsonObject()) {
            throw new JsonSyntaxException("Expected '" + key + "' to be an object");
        }
    }

    public static ChemicalType getChemicalType(@Nonnull JsonObject json) {
        if (!json.has("chemicalType")) {
            throw new JsonSyntaxException("Missing 'chemicalType', expected to find a string");
        }
        JsonElement element = json.get("chemicalType");
        if (!element.isJsonPrimitive()) {
            throw new JsonSyntaxException("Expected 'chemicalType' to be a json primitive representing a string");
        }
        String name = element.getAsString();
        ChemicalType chemicalType = ChemicalType.fromString(name);
        if (chemicalType == null) {
            throw new JsonSyntaxException("Invalid chemical type '" + name + "'.");
        }
        return chemicalType;
    }

    public static ItemStack getItemStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static FluidStack getFluidStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeFluid(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static ChemicalStack<?> getBoxedChemicalStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        JsonObject jsonObject = GsonHelper.m_13930_((JsonObject)json, (String)key);
        ChemicalType chemicalType = SerializerHelper.getChemicalType(jsonObject);
        return switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> SerializerHelper.deserializeGas(jsonObject);
            case ChemicalType.INFUSION -> SerializerHelper.deserializeInfuseType(jsonObject);
            case ChemicalType.PIGMENT -> SerializerHelper.deserializePigment(jsonObject);
            case ChemicalType.SLURRY -> SerializerHelper.deserializeSlurry(jsonObject);
        };
    }

    public static GasStack getGasStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeGas(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static InfusionStack getInfusionStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeInfuseType(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static PigmentStack getPigmentStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializePigment(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static SlurryStack getSlurryStack(@Nonnull JsonObject json, @Nonnull String key) {
        SerializerHelper.validateKey(json, key);
        return SerializerHelper.deserializeSlurry(GsonHelper.m_13930_((JsonObject)json, (String)key));
    }

    public static FluidStack deserializeFluid(@Nonnull JsonObject json) {
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
        }
        JsonElement count = json.get("amount");
        if (!GsonHelper.m_13872_((JsonElement)count)) {
            throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
        }
        int amount = count.getAsJsonPrimitive().getAsInt();
        if (amount < 1) {
            throw new JsonSyntaxException("Expected amount to be greater than zero.");
        }
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourceLocation);
        if (fluid == null || fluid == Fluids.f_76191_) {
            throw new JsonSyntaxException("Invalid fluid type '" + resourceLocation + "'");
        }
        CompoundTag nbt = null;
        if (json.has("nbt")) {
            JsonElement jsonNBT = json.get("nbt");
            try {
                nbt = jsonNBT.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(jsonNBT)) : TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)jsonNBT, (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT entry for fluid '" + resourceLocation + "'");
            }
        }
        return new FluidStack(fluid, amount, nbt);
    }

    public static GasStack deserializeGas(@Nonnull JsonObject json) {
        return (GasStack)SerializerHelper.deserializeChemicalStack(json, "gas", Gas::getFromRegistry);
    }

    public static InfusionStack deserializeInfuseType(@Nonnull JsonObject json) {
        return (InfusionStack)SerializerHelper.deserializeChemicalStack(json, "infuse_type", InfuseType::getFromRegistry);
    }

    public static PigmentStack deserializePigment(@Nonnull JsonObject json) {
        return (PigmentStack)SerializerHelper.deserializeChemicalStack(json, "pigment", Pigment::getFromRegistry);
    }

    public static SlurryStack deserializeSlurry(@Nonnull JsonObject json) {
        return (SlurryStack)SerializerHelper.deserializeChemicalStack(json, "slurry", Slurry::getFromRegistry);
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK deserializeChemicalStack(@Nonnull JsonObject json, @Nonnull String serializationKey, @Nonnull Function<ResourceLocation, CHEMICAL> fromRegistry) {
        if (!json.has("amount")) {
            throw new JsonSyntaxException("Expected to receive a amount that is greater than zero");
        }
        JsonElement count = json.get("amount");
        if (!GsonHelper.m_13872_((JsonElement)count)) {
            throw new JsonSyntaxException("Expected amount to be a number greater than zero.");
        }
        long amount = count.getAsJsonPrimitive().getAsLong();
        if (amount < 1L) {
            throw new JsonSyntaxException("Expected amount to be greater than zero.");
        }
        ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)serializationKey));
        Chemical chemical = (Chemical)fromRegistry.apply(resourceLocation);
        if (chemical.isEmptyType()) {
            throw new JsonSyntaxException("Invalid " + serializationKey + " type '" + resourceLocation + "'");
        }
        return (STACK)chemical.getStack(amount);
    }

    public static JsonElement serializeItemStack(@Nonnull ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", stack.m_41720_().getRegistryName().toString());
        if (stack.m_41613_() > 1) {
            json.addProperty("count", (Number)stack.m_41613_());
        }
        if (stack.m_41782_()) {
            json.addProperty("nbt", stack.m_41783_().toString());
        }
        return json;
    }

    public static JsonElement serializeFluidStack(@Nonnull FluidStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("fluid", stack.getFluid().getRegistryName().toString());
        json.addProperty("amount", (Number)stack.getAmount());
        if (stack.hasTag()) {
            json.addProperty("nbt", stack.getTag().toString());
        }
        return json;
    }

    public static JsonElement serializeBoxedChemicalStack(@Nonnull BoxedChemicalStack stack) {
        ChemicalType chemicalType = stack.getChemicalType();
        JsonObject json = switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> SerializerHelper.serializeGasStack((GasStack)stack.getChemicalStack());
            case ChemicalType.INFUSION -> SerializerHelper.serializeInfusionStack((InfusionStack)stack.getChemicalStack());
            case ChemicalType.PIGMENT -> SerializerHelper.serializePigmentStack((PigmentStack)stack.getChemicalStack());
            case ChemicalType.SLURRY -> SerializerHelper.serializeSlurryStack((SlurryStack)stack.getChemicalStack());
        };
        json.addProperty("chemicalType", chemicalType.m_7912_());
        return json;
    }

    public static JsonObject serializeGasStack(@Nonnull GasStack stack) {
        return SerializerHelper.serializeChemicalStack("gas", stack);
    }

    public static JsonObject serializeInfusionStack(@Nonnull InfusionStack stack) {
        return SerializerHelper.serializeChemicalStack("infuse_type", stack);
    }

    public static JsonObject serializePigmentStack(@Nonnull PigmentStack stack) {
        return SerializerHelper.serializeChemicalStack("pigment", stack);
    }

    public static JsonObject serializeSlurryStack(@Nonnull SlurryStack stack) {
        return SerializerHelper.serializeChemicalStack("slurry", stack);
    }

    private static JsonObject serializeChemicalStack(@Nonnull String serializationKey, @Nonnull ChemicalStack<?> stack) {
        JsonObject json = new JsonObject();
        json.addProperty(serializationKey, stack.getType().getRegistryName().toString());
        json.addProperty("amount", (Number)stack.getAmount());
        return json;
    }
}

